// GMSH script to generate the mesh for the hole plate example
// Documentation: https://gmsh.info/doc/texinfo/gmsh.html
// Author: Andrea Pavan
// Date: 30/01/2023


//parameters
l1 = 20.0;		//domain x size
l2 = 1.0;       //domain y size
surfaceMeshSize = 0.2;		//mesh size at the boundaries


//change geometry kernel
SetFactory("OpenCASCADE");


//-----------------------
//  geometry creation
//-----------------------

Point(1) = {0, 0, 0, surfaceMeshSize};
Point(2) = {l1, 0, 0, surfaceMeshSize};
Point(3) = {l1, l2, 0, surfaceMeshSize};
Point(4) = {0, l2, 0, surfaceMeshSize};

Line(1) = {1, 2};
Line(2) = {2, 3};
Line(3) = {3, 4};
Line(4) = {4, 1};

Curve Loop(1) = {1:4};
Plane Surface(1) = {1};
Physical Curve("boundary") = {1:4};
